﻿using System;
using System.Web;
using System.Linq;
using System.Collections.Generic;
using System.Web.UI.WebControls;
using System.Web.Security.AntiXss;
using VIRP;
using VIRP_WEB.BaseCode;
using VIRP_WEB.SoaServices;

namespace VIRP_WEB.Custom.EFR
{
    public partial class LabKitInProcessOrders : EfrBasePage
    {
        private int OrderType;

        protected override void Page_Load(object sender, EventArgs e)
        {
            // Added for 508 compliance with GridView column headers and footer
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridViewLabKitOrders.ClientID + "');", true);
        }

        protected override void OnInitComplete(EventArgs e)
        {
            GetOrderType();
            if (OrderType == Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Tracking))
            {
                ObjectDataSourceLabKitOrders.SelectMethod = "GetOrderedKitOrders";
                ObjectDataSourceLabKitOrders.SelectCountMethod = "GetOrderedKitOrdersCount";
                GridViewLabKitOrders.Columns[9].Visible = false;
                GridViewLabKitOrders.Columns[10].Visible = false;
                //btnSave.Visible = true;
            }
            if (OrderType == Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Received))
            {
                ObjectDataSourceLabKitOrders.SelectMethod = "GetLabKitsReturned";
                ObjectDataSourceLabKitOrders.SelectCountMethod = "GetLabKitsReturnedCount";
                GridViewLabKitOrders.Columns[10].Visible = false;
            }
            if (OrderType == Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided))
            {
                ObjectDataSourceLabKitOrders.SelectMethod = "GetLabKitsCanceled";
                ObjectDataSourceLabKitOrders.SelectCountMethod = "GetLabKitsCanceledCount";
                GridViewLabKitOrders.Columns[9].Visible = false;
            }
            base.OnInitComplete(e);
        }

        protected override void OnInit(EventArgs e)
        {
            //GetOrderType();
            //if (OrderType == Convert.ToInt16(WorkflowCaseActivityStatus.Ordered))
            //{
            //    ObjectDataSource1.SelectMethod = "GetOrderedKitOrders";
            //    GridView1.Columns[7].Visible = false;
            //    GridView1.Columns[8].Visible = false;
            //    btnSave.Visible = true;
            //}
            //if (OrderType == Convert.ToInt16(WorkflowCaseActivityStatus.Received))
            //{
            //    ObjectDataSource1.SelectMethod = "GetLabKitsReturned";
            //    GridView1.Columns[8].Visible = false;
            //}
            //if (OrderType == Convert.ToInt16(WorkflowCaseActivityStatus.Canceled))
            //{
            //    ObjectDataSource1.SelectMethod = "GetLabKitsCanceled";
            //    GridView1.Columns[7].Visible = false;
            //}
            base.OnInit(e);
        }
        protected void SelectActivity(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Details")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewLabKitOrders.SelectedIndex = index;
                Int32 ActivityId = Convert.ToInt32(GridViewLabKitOrders.SelectedDataKey.Values[0]);
                Response.Redirect(string.Format("LabKitDetails.aspx?ActivityId={0}", ActivityId), false);
            }
        }

        protected void ObjectDataSource1_Selected(object sender, ObjectDataSourceStatusEventArgs e)
        {
            if (e.ReturnValue != null && !e.ReturnValue.GetType().IsValueType)
                if (((IEnumerable<KitOrders>)e.ReturnValue).Count() == 0)
                {
                    GridViewLabKitOrders.EmptyDataText = "No records found for the " + Enum.GetName(typeof(VIRP.EFR.BO.WorkflowCaseActivityStatus), OrderType).AddSpacesToCamelCase() + " lab kits.";

                    btnSave.Visible = false;
                }
        }

        private void GetOrderType()
        {
            if (!IsPostBack)
            {
                OrderType = Convert.ToInt16(AntiXssEncoder.HtmlEncode(Request.QueryString["OrderType"], false));
                //ViewState["OrderType"] = OrderType;
                //TODO - Move breadcrumb logic to menubuilder and master page. Added here to avoid error out in Referral pages.

                ((Label)Master.FindControl("EfrPageTitle")).Text = "My Tasks > Lab Kits > " + Enum.GetName(typeof(VIRP.EFR.BO.WorkflowCaseActivityStatus), OrderType).AddSpacesToCamelCase();
            }
            //For paging
            //OrderType = Convert.ToInt16(ViewState["OrderType"]);
            else
            {
                OrderType = Convert.ToInt16(AntiXssEncoder.HtmlEncode(Request.QueryString["OrderType"], false));
            }
        }

        protected void ButtonOK_Click(object sender, EventArgs e)
        {
            GridViewLabKitOrders.PageIndex = 0;
        }

        public string DisplayFormatOrderedDate(DateTime? date)
        {
            if (date.HasValue)
                return date.Value.ToString("d");
            else
                return "Used Stock";
        }

        protected void BtnSave_Click(object sender, EventArgs e)
        {
            Response.Redirect("LabKitsReport.aspx");
        }

        protected void ButtonClear_Click(object sender, EventArgs e)
        {
            ButtonOK_Click(sender, e);
        }

        protected override void Ds_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                //e.InputParameters.Clear();

                //string txtSearch = TextBoxSearchCriteria.Text;
                //string listFacility = DropDownListFacility.SelectedValue;

                if (e.InputParameters["CURRENT_USER"] != null)
                    e.InputParameters["CURRENT_USER"] = HttpContext.Current.User.Identity.Name;
                else
                    e.InputParameters.Add("CURRENT_USER", HttpContext.Current.User.Identity.Name);

                if (e.InputParameters["CURRENT_REGISTRY_ID"] != null)
                    e.InputParameters["CURRENT_REGISTRY_ID"] = UserSession.CurrentRegistryId;
                else
                    e.InputParameters.Add("CURRENT_REGISTRY_ID", UserSession.CurrentRegistryId);

                //e.InputParameters.Add("lastName", txtSearch);
                //e.InputParameters.Add("facilityId", listFacility);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }
    }
}
